"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.throwsAnyError = void 0;
const is_function_1 = require("./is-function");
/**
 * Asserts that a value is a `Function` which throws when invoked.
 *
 * @tags guard, functions, errors
 */
const throwsAnyError = (value) => {
    try {
        if (!(0, is_function_1.isFunction)(value))
            return false;
        value();
        return false;
    }
    catch (err) {
        return true;
    }
};
exports.throwsAnyError = throwsAnyError;
