"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.startsWith = void 0;
const curry_1 = require("../fn/curry");
const is_non_empty_string_1 = require("./is-non-empty-string");
/**
 * Asserts that value is a string whose trailing characters are equal to those of the provided string.
 *
 * @tags guard, strings, string-length, comparator
 */
exports.startsWith = (0, curry_1.curry)((otherString, value) => (0, is_non_empty_string_1.isNonEmptyString)(value) &&
    (0, is_non_empty_string_1.isNonEmptyString)(otherString) &&
    value.slice(0, otherString.length) === otherString, 2);
