"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.some = void 0;
const curry_1 = require("../fn/curry");
const is_non_empty_array_1 = require("./is-non-empty-array");
/**
 * Returns true if array is not empty and any member of the array passes the guard
 *
 * @tags guard
 */
exports.some = (0, curry_1.curry)((guard, array) => (0, is_non_empty_array_1.isNonEmptyArray)(array) && array.some(guard), 2);
