"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.is = void 0;
const curry_1 = require("../fn/curry");
/**
 * Returns whether both values are referentially equal, ie. `a === b`. This will be the case when both values are
 * primitives (undefined, number, null, string, or boolean) or they are objects which both point to the same address in
 * memory.
 *
 * @tags guard, comparator
 */
exports.is = (0, curry_1.curry)((b, a) => b === a, 2);
