"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isWithinRange = void 0;
const curry_1 = require("../fn/curry");
const is_greater_than_or_equal_to_1 = require("./is-greater-than-or-equal-to");
const is_less_than_or_equal_to_1 = require("./is-less-than-or-equal-to");
/**
 * Asserts that a value is a `Number` which is both greater than or equal to `floor` and less than or equal to
 * `ceiling`.
 *
 * @tags guard, numbers
 */
exports.isWithinRange = (0, curry_1.curry)((floor, ceiling, value) => (0, is_less_than_or_equal_to_1.isLessThanOrEqualTo)(ceiling, value) && (0, is_greater_than_or_equal_to_1.isGreaterThanOrEqualTo)(floor, value), 3);
