"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isWholeNumber = void 0;
const is_divisible_by_1 = require("./is-divisible-by");
const is_number_1 = require("./is-number");
/**
 * Asserts that a value is a `Number` with no positive decimal places.
 *
 * @tags guard, numbers
 */
const isWholeNumber = (value) => (0, is_number_1.isNumber)(value) && (value === 0 || (0, is_divisible_by_1.isDivisibleBy)(1, value));
exports.isWholeNumber = isWholeNumber;
