"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isWhitespace = void 0;
const is_string_1 = require("./is-string");
/**
 * Asserts that a value is a `String` containing only whitespace characters.
 *
 * @tags guard, strings
 */
const isWhitespace = (value) => (0, is_string_1.isString)(value) && value.search(/\S/) === -1;
exports.isWhitespace = isWhitespace;
