"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isVisibleString = void 0;
const is_string_1 = require("./is-string");
/**
 * Asserts that a value is a valid `String` containing at least one character which is not whitespace.
 *
 * @tags guard, strings
 */
const isVisibleString = (value) => (0, is_string_1.isString)(value) && value.length > 0 && value.search(/\S/) !== -1;
exports.isVisibleString = isVisibleString;
