"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isValidDate = void 0;
const is_date_1 = require("./is-date");
/**
 * Asserts that a value is an instance of `Date` whose internal value is valid. `Date` is little like `Promise` in that
 * it is a container for a value. For example, `new Date('wut?')` is a valid `Date` which wraps a value that is not
 * valid.
 *
 * @tags guard, dates
 */
const isValidDate = (value) => (0, is_date_1.isDate)(value) && !isNaN(value.getTime());
exports.isValidDate = isValidDate;
