"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isTrue = void 0;
const is_boolean_1 = require("./is-boolean");
/**
 * Asserts that a value is `true` or `new Boolean(true)`.
 *
 * @tags guard, booleans
 */
const isTrue = (value) => value === true || ((0, is_boolean_1.isBoolean)(value) && value.valueOf() === true);
exports.isTrue = isTrue;
