"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isOddNumber = void 0;
const is_divisible_by_1 = require("./is-divisible-by");
const is_number_1 = require("./is-number");
/**
 * Asserts that a value is an odd `Number`.
 *
 * @tags guard, numbers
 */
const isOddNumber = (value) => (0, is_number_1.isNumber)(value) && !(0, is_divisible_by_1.isDivisibleBy)(2, value);
exports.isOddNumber = isOddNumber;
