"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isNumber = void 0;
const has_type_1 = require("./has-type");
/**
 * Asserts that a value is a valid `Number` or `new Number()` and not `NaN`.
 *
 * @tags guard, numbers
 */
const isNumber = (value) => (0, has_type_1.hasType)('Number')(value) && !isNaN(parseFloat(String(value)));
exports.isNumber = isNumber;
