"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isNonEmptyString = void 0;
const is_string_1 = require("./is-string");
/**
 * Asserts that a value is a valid `String` containing at least one character.
 *
 * @tags guard, strings, emptiness, truthiness
 */
const isNonEmptyString = (value) => (0, is_string_1.isString)(value) && value.length > 0;
exports.isNonEmptyString = isNonEmptyString;
