"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isNonEmptyObject = void 0;
const is_object_1 = require("./is-object");
/**
 * Asserts that a value is an `Object` containing at least one own member.
 *
 * @tags guard, objects, emptiness
 */
function isNonEmptyObject(value) {
    return (0, is_object_1.isObject)(value) && Object.keys(value).length > 0;
}
exports.isNonEmptyObject = isNonEmptyObject;
