"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isNonEmptyArray = void 0;
const is_array_1 = require("./is-array");
/**
 * Asserts that a value is an `Array` containing at least one value.
 *
 * @tags guard, arrays, emptiness
 */
const isNonEmptyArray = (value) => (0, is_array_1.isArray)(value) && value.length > 0;
exports.isNonEmptyArray = isNonEmptyArray;
