"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isNil = void 0;
const is_null_1 = require("./is-null");
const is_undefined_1 = require("./is-undefined");
/**
 * Asserts that a value is `null` or `undefined`
 *
 * @tags guard, truthiness
 */
const isNil = (value) => (0, is_null_1.isNull)(value) || (0, is_undefined_1.isUndefined)(value);
exports.isNil = isNil;
