"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isNegativeNumber = void 0;
const is_number_1 = require("./is-number");
/**
 * Asserts that a value is a `Number` less than 0.
 *
 * @tags guard, numbers, comparator
 */
const isNegativeNumber = (value) => (0, is_number_1.isNumber)(value) && value < 0;
exports.isNegativeNumber = isNegativeNumber;
