"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isNear = void 0;
const curry_1 = require("../fn/curry");
const is_within_range_1 = require("./is-within-range");
/**
 * Asserts that a value is a number within the given acceptable distance from another.
 *
 * @tags guard, numbers, comparator
 */
exports.isNear = (0, curry_1.curry)((otherNumber, epsilon, value) => (0, is_within_range_1.isWithinRange)(otherNumber - epsilon, otherNumber + epsilon, value), 3);
