"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isLessThan = void 0;
const curry_1 = require("../fn/curry");
const is_number_1 = require("./is-number");
/**
 * Asserts that a value is less than another.
 *
 * @tags guard, numbers, comparator
 */
exports.isLessThan = (0, curry_1.curry)((other, value) => (0, is_number_1.isNumber)(value) && (0, is_number_1.isNumber)(other) && value < other, 2);
