"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isLessThanOrEqualTo = void 0;
const curry_1 = require("../fn/curry");
const is_number_1 = require("./is-number");
/**
 * Asserts that a value is less than or equal to another.
 *
 * @tags guard, numbers, comparator
 */
exports.isLessThanOrEqualTo = (0, curry_1.curry)((other, value) => (0, is_number_1.isNumber)(value) && (0, is_number_1.isNumber)(other) && value <= other, 2);
