"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isJsonString = void 0;
const is_calculable_1 = require("./is-calculable");
const is_string_1 = require("./is-string");
/**
 * Asserts that a value is a `String` of valid JSON.
 *
 * @tags guard, strings, JSON
 */
const isJsonString = (value) => {
    try {
        return (value === 'null' ||
            ((0, is_string_1.isString)(value) && ((0, is_calculable_1.isCalculable)(value) || JSON.parse(value) !== null)));
    }
    catch (err) {
        return false;
    }
};
exports.isJsonString = isJsonString;
