"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isIso8601 = void 0;
const is_string_1 = require("./is-string");
const is_valid_date_1 = require("./is-valid-date");
/**
 * Asserts that a value is a String which conforms to common use-cases of the ISO 8601 standard representation of dates
 * and times.
 *
 * @tags guard, strings, dates
 */
const isIso8601 = (value) => {
    // '1999-12-31'
    // '1999-12-31T23:59'
    // '1999-12-31T23:59:59'
    // '1999-12-31T23:59:59.000'
    // '1999-12-31T23:59:59.000Z'
    // '1999-12-31T23:59:59+01:00'
    // '1999-12-31T23:59:59-01:00'
    // '1999-12-31T23:59:59.000+01:00'
    // '1999-12-31T23:59:59.000-01:00'
    return ((0, is_string_1.isString)(value) &&
        (/^([0-9]{4})-([0-9]{2})-([0-9]{2})$/.test(value) ||
            /^([0-9]{4})-([0-9]{2})-([0-9]{2})T([0-9]{2}):([0-9]{2})$/.test(value) ||
            /^([0-9]{4})-([0-9]{2})-([0-9]{2})T([0-9]{2}):([0-9]{2}):([0-9]{2})$/.test(value) ||
            /^([0-9]{4})-([0-9]{2})-([0-9]{2})T([0-9]{2}):([0-9]{2}):([0-9]{2})\.([0-9]{3})$/.test(value) ||
            /^([0-9]{4})-([0-9]{2})-([0-9]{2})T([0-9]{2}):([0-9]{2}):([0-9]{2})\.([0-9]{3})Z$/.test(value) ||
            /^([0-9]{4})-([0-9]{2})-([0-9]{2})T([0-9]{2}):([0-9]{2}):([0-9]{2})([+-][0-9]{2}:[0-9]{2})$/.test(value) ||
            /^([0-9]{4})-([0-9]{2})-([0-9]{2})T([0-9]{2}):([0-9]{2}):([0-9]{2})\.([0-9]{3})([+-][0-9]{2}:[0-9]{2})$/.test(value)) &&
        (0, is_valid_date_1.isValidDate)(new Date(value)));
};
exports.isIso8601 = isIso8601;
