"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isGreaterThan = void 0;
const curry_1 = require("../fn/curry");
const is_number_1 = require("./is-number");
/**
 * Asserts that a value is greater than another.
 *
 * @tags guard, numbers, comparator
 */
exports.isGreaterThan = (0, curry_1.curry)((other, value) => (0, is_number_1.isNumber)(value) && (0, is_number_1.isNumber)(other) && value > other, 2);
