"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isFalse = void 0;
const is_boolean_1 = require("./is-boolean");
/**
 * Asserts that a value is `false` or `new Boolean(false)`.
 *
 * @tags guard, booleans
 */
const isFalse = (value) => value === false || ((0, is_boolean_1.isBoolean)(value) && value.valueOf() === false);
exports.isFalse = isFalse;
