"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isEvenNumber = void 0;
const is_divisible_by_1 = require("./is-divisible-by");
const is_number_1 = require("./is-number");
/**
 * Asserts that a value is an even `Number`.
 *
 * @tags guard, numbers
 */
const isEvenNumber = (value) => (0, is_number_1.isNumber)(value) && (0, is_divisible_by_1.isDivisibleBy)(2, value);
exports.isEvenNumber = isEvenNumber;
