"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isEmptyString = void 0;
const is_string_1 = require("./is-string");
/**
 * Asserts that a value is a valid `String` containing no characters.
 *
 * @tags guard, strings, string-length, emptiness, truthiness
 */
const isEmptyString = (value) => (0, is_string_1.isString)(value) && value.length === 0;
exports.isEmptyString = isEmptyString;
