"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isEmptyObject = void 0;
const is_object_1 = require("./is-object");
/**
 * Asserts that a value is a valid `Object` containing no instance members.
 *
 * @tags guard, objects, emptiness
 */
const isEmptyObject = (value) => (0, is_object_1.isObject)(value) && Object.keys(value).length === 0;
exports.isEmptyObject = isEmptyObject;
