"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isEmptyArray = void 0;
const is_array_of_size_1 = require("./is-array-of-size");
/**
 * Asserts that a value is a valid `Array` containing no items.
 *
 * @tags guard, arrays, array-length, emptiness
 */
const isEmptyArray = (value) => (0, is_array_of_size_1.isArrayOfSize)(0, value);
exports.isEmptyArray = isEmptyArray;
