"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isDivisibleBy = void 0;
const curry_1 = require("../fn/curry");
const is_number_1 = require("./is-number");
/**
 * Asserts that a value is a `Number` which results in a whole number when divided by another.
 *
 * @tags guard, numbers
 */
exports.isDivisibleBy = (0, curry_1.curry)((other, value) => (0, is_number_1.isNumber)(value) && (0, is_number_1.isNumber)(other) && value % other === 0, 2);
