"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isDecimalNumber = void 0;
const is_number_1 = require("./is-number");
/**
 * Asserts that a value is a `Number` with positive decimal places.
 *
 * @tags guard, numbers
 */
const isDecimalNumber = (value) => (0, is_number_1.isNumber)(value) && String(value).indexOf('.') !== -1;
exports.isDecimalNumber = isDecimalNumber;
