"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isDateOnOrBefore = void 0;
const curry_1 = require("../fn/curry");
const is_date_1 = require("./is-date");
const is_less_than_or_equal_to_1 = require("./is-less-than-or-equal-to");
/**
 * Asserts that a value is an instance of `Date` occurring on or before the exact date and time of another.
 *
 * @tags guard, dates, comparator
 */
exports.isDateOnOrBefore = (0, curry_1.curry)((other, value) => (0, is_date_1.isDate)(value) &&
    (0, is_date_1.isDate)(other) &&
    (0, is_less_than_or_equal_to_1.isLessThanOrEqualTo)(other.getTime(), value.getTime()), 2);
