"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isDateOnDayOfWeek = void 0;
const curry_1 = require("../fn/curry");
const is_date_1 = require("./is-date");
const is_number_1 = require("./is-number");
/**
 * Asserts that a value is an instance of `Date` occurring on the day of the week with the given index, where Sunday is
 * `0` and Saturday is `6`.
 *
 * @tags guard, dates, comparator
 */
exports.isDateOnDayOfWeek = (0, curry_1.curry)((index, value) => (0, is_date_1.isDate)(value) && (0, is_number_1.isNumber)(index) && value.getDay() === index, 2);
