"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isDateOnDayOfMonth = void 0;
const curry_1 = require("../fn/curry");
const is_date_1 = require("./is-date");
const is_number_1 = require("./is-number");
/**
 * Asserts that a value is an instance of `Date` occurring on the given day of the month, where the first day of the
 * month is `1` and last is `31`.
 *
 * @tags guard, dates, comparator
 */
exports.isDateOnDayOfMonth = (0, curry_1.curry)((dayOfMonth, value) => (0, is_date_1.isDate)(value) && (0, is_number_1.isNumber)(dayOfMonth) && value.getDate() === dayOfMonth, 2);
