"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isDateInYear = void 0;
const curry_1 = require("../fn/curry");
const is_date_1 = require("./is-date");
const is_number_1 = require("./is-number");
/**
 * Asserts that a value is an instance of `Date` occurring in the given year.
 *
 * @tags guard, dates, comparator
 */
exports.isDateInYear = (0, curry_1.curry)((year, value) => (0, is_date_1.isDate)(value) && (0, is_number_1.isNumber)(year) && value.getFullYear() === year, 2);
