"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isDateInMonth = void 0;
const curry_1 = require("../fn/curry");
const is_date_1 = require("./is-date");
const is_number_1 = require("./is-number");
/**
 * Asserts that a value is an instance of `Date` occurring on the given month of the year, where January is `0` and
 * December is `11`.
 *
 * @tags guard, dates, comparator
 */
exports.isDateInMonth = (0, curry_1.curry)((index, value) => (0, is_date_1.isDate)(value) && (0, is_number_1.isNumber)(index) && value.getMonth() === index, 2);
