"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isDateBetween = void 0;
const curry_1 = require("../fn/curry");
const is_date_1 = require("./is-date");
const is_greater_than_or_equal_to_1 = require("./is-greater-than-or-equal-to");
const is_less_than_or_equal_to_1 = require("./is-less-than-or-equal-to");
/**
 * Asserts that a value is an instance of `Date` occurring on or after `floor` and on or before `ceiling`.
 *
 * @tags guard, dates, comparator
 */
exports.isDateBetween = (0, curry_1.curry)((floor, ceiling, date) => (0, is_date_1.isDate)(date) &&
    (0, is_date_1.isDate)(floor) &&
    (0, is_date_1.isDate)(ceiling) &&
    (0, is_less_than_or_equal_to_1.isLessThanOrEqualTo)(ceiling.getTime(), date.getTime()) &&
    (0, is_greater_than_or_equal_to_1.isGreaterThanOrEqualTo)(floor.getTime(), date.getTime()), 3);
