"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isCalculable = void 0;
/**
 * Assert value can be used in Mathemetic calculations despite not being a `Number`, for example `'1' * '2' === 2`
 * whereas `'wut?' * 2 === NaN`.
 *
 * @tags guard, strings, numbers
 */
const isCalculable = (value) => !isNaN(value * 2);
exports.isCalculable = isCalculable;
