"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isBefore = void 0;
const curry_1 = require("../fn/curry");
const is_after_1 = require("./is-after");
/**
 * Asserts that a value is a valid instance of `Date` whose value occurs before that of another.
 *
 * @tags guard, dates, comparator
 */
exports.isBefore = (0, curry_1.curry)((other, value) => (0, is_after_1.isAfter)(value, other), 2);
