"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isArrayOf = void 0;
const curry_1 = require("../fn/curry");
const is_non_empty_array_1 = require("./is-non-empty-array");
/**
 * Does every value pass the given Guard?
 *
 * ## Examples
 *
 * ```ts
 * isArrayOf(isNonEmptyString, ['click', 'mousedown', 'load']);
 * ```
 *
 * @tags guard, arrays
 */
exports.isArrayOf = (0, curry_1.curry)((guard, values) => (0, is_non_empty_array_1.isNonEmptyArray)(values) && values.every((value) => guard(value)), 2);
