"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isArrayOfStrings = void 0;
const every_1 = require("./every");
const is_string_1 = require("./is-string");
/**
 * Asserts that a value is an `Array` containing only `String` values.
 *
 * @tags guard, arrays, strings
 */
const isArrayOfStrings = (value) => (0, every_1.every)(is_string_1.isString, value);
exports.isArrayOfStrings = isArrayOfStrings;
