"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isArrayOfSize = void 0;
const curry_1 = require("../fn/curry");
const is_array_1 = require("./is-array");
/**
 * Asserts that a value is an `Array` containing a specific number of values.
 *
 * @tags guard, arrays, array-length
 */
exports.isArrayOfSize = (0, curry_1.curry)((size, value) => (0, is_array_1.isArray)(value) && value.length === size, 2);
