"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isArrayOfObjects = void 0;
const is_array_of_1 = require("./is-array-of");
const is_object_1 = require("./is-object");
/**
 * Asserts that a value is an `Array` containing only `Object` values.
 *
 * ## Examples
 *
 * ```ts
 * isArrayOfObjects([{}, new Object()]);
 * ```
 *
 * @tags guard, arrays, objects
 */
exports.isArrayOfObjects = (0, is_array_of_1.isArrayOf)(is_object_1.isObject);
