"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isArrayOfBooleans = void 0;
const is_array_of_1 = require("./is-array-of");
const is_boolean_1 = require("./is-boolean");
/**
 * Asserts that a value is an `Array` containing only `Boolean` values.
 *
 * ## Examples
 *
 * ```ts
 * isArrayOfBooleans([true, false, new Boolean(true)]);
 * ```
 *
 * @tags guard, arrays, booleans
 */
exports.isArrayOfBooleans = (0, is_array_of_1.isArrayOf)(is_boolean_1.isBoolean);
