"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isArrayIncludingOnly = void 0;
const curry_1 = require("../fn/curry");
const every_1 = require("./every");
const is_array_1 = require("./is-array");
const is_jest_equal_1 = require("./is-jest-equal");
const some_1 = require("./some");
/**
 * Asserts that a value is an `Array` including only the values provided in the given `allowedValues` array and no
 * others. The order and number of times each value appears in either array does not matter. Returns true unless `value`
 * contains a value which does not feature in `allowedValues`.
 *
 * @tags guard, arrays, multiple-conditions
 */
exports.isArrayIncludingOnly = (0, curry_1.curry)((allowedValues, value) => (0, is_array_1.isArray)(allowedValues) &&
    (0, is_array_1.isArray)(value) &&
    (0, every_1.every)((member) => (0, some_1.some)((0, is_jest_equal_1.isJestEqual)(member), allowedValues), value), 2);
