"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isArrayIncludingAnyOf = void 0;
const curry_1 = require("../fn/curry");
const is_array_1 = require("./is-array");
const is_jest_equal_1 = require("./is-jest-equal");
const some_1 = require("./some");
/**
 * Asserts that `value` is an `Array` including at least one of the members of `allowedValues`.
 *
 * @tags guard, arrays, multiple-conditions
 */
exports.isArrayIncludingAnyOf = (0, curry_1.curry)((allowedValues, value) => (0, is_array_1.isArray)(allowedValues) &&
    (0, is_array_1.isArray)(value) &&
    (0, some_1.some)((allowedValue) => (0, some_1.some)((0, is_jest_equal_1.isJestEqual)(allowedValue), value), allowedValues), 2);
