"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isArrayIncludingAllOf = void 0;
const curry_1 = require("../fn/curry");
const every_1 = require("./every");
const is_array_1 = require("./is-array");
const is_jest_equal_1 = require("./is-jest-equal");
const some_1 = require("./some");
/**
 * Asserts that `value` is an `Array` including all of the values provided in `requiredValues`. It could also include
 * additional values or be in a different order, but if every value in `requiredValues` features in `value` then this
 * will return `true`.
 *
 * @tags guard, arrays, multiple-conditions
 */
exports.isArrayIncludingAllOf = (0, curry_1.curry)((requiredValues, value) => (0, is_array_1.isArray)(requiredValues) &&
    (0, is_array_1.isArray)(value) &&
    (0, every_1.every)((requiredValue) => (0, some_1.some)((0, is_jest_equal_1.isJestEqual)(requiredValue), value), requiredValues), 2);
