type IsArrayIncludingAllOf = {
    (requiredValues: unknown[]): {
        (value: unknown): boolean;
    };
    (requiredValues: unknown[], value: unknown): boolean;
};
/**
 * Asserts that `value` is an `Array` including all of the values provided in `requiredValues`. It could also include
 * additional values or be in a different order, but if every value in `requiredValues` features in `value` then this
 * will return `true`.
 *
 * @tags guard, arrays, multiple-conditions
 */
export declare const isArrayIncludingAllOf: IsArrayIncludingAllOf;
export {};
