"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isAfter = void 0;
const curry_1 = require("../fn/curry");
const is_date_1 = require("./is-date");
/**
 * Asserts that a value is a valid instance of `Date` whose value occurs after that of another.
 *
 * @tags guard, dates, comparator
 */
exports.isAfter = (0, curry_1.curry)((otherDate, date) => (0, is_date_1.isDate)(date) && (0, is_date_1.isDate)(otherDate) && date.getTime() > otherDate.getTime(), 2);
