"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.hasProperty = void 0;
const curry_1 = require("../fn/curry");
const is_string_1 = require("./is-string");
/**
 * Returns true if a value has a property of the given name, even if the value of that property is `undefined`.
 *
 * This assertion describes the shape of the given value. For example, value.prop is `undefined` in both of the
 * following scenarios, but `{ prop: undefined }` and `{ }` do not have the same shape.
 *
 * @tags guard, objects, arrays
 */
exports.hasProperty = (0, curry_1.curry)((ownKeyName, value) => Boolean((0, is_string_1.isString)(ownKeyName) &&
    value &&
    typeof value === 'object' &&
    ownKeyName in value), 2);
