"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.every = void 0;
const curry_1 = require("../fn/curry");
const is_non_empty_array_1 = require("./is-non-empty-array");
/**
 * Return true if `value` is a non-empty array and every member passes the given guard.
 *
 * ## Examples
 *
 * ```ts
 * import { every } from 'tightrope/guard/every';
 * import { isPositiveNumber } from 'tightrope/guard/is-positive-number';
 *
 * const numbers = [1, 2, 3, 4, 5];
 * const isArrayOfPositiveNumbers = every(isPositiveNumber);
 *
 * isArrayOfPositiveNumbers(numbers); // true
 * ```
 *
 * @tags guard, multiple-conditions
 */
exports.every = (0, curry_1.curry)((guard, value) => (0, is_non_empty_array_1.isNonEmptyArray)(value) && value.every(guard), 2);
